/** @file   alien.cpp
 * @brief   Implementation of Alien - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#include "alien.h" // class's header file
#include "www_map.h"
#include "GfxManager.h"
#include "redrawqueue.h"
#include "animplayer.h"
#include "gameanims.h"
#include "warglobals.h"
using std::vector;


namespace WeWantWar {

const int Alien::RELOAD_COUNTER_INDEX;



// class constructor
Alien::Alien( ) :
  GameObject( ),
  m_pGfxTable( 0 )
{
	this->setProperties( GameObject::PROP_GRENADEFORCE |
                       GameObject::PROP_SHOTPARALYSES );
}

// class destructor
Alien::~Alien()
{
	
}


/** Handles the bullethit
 */
bool Alien::hitByBullet( Bullet* pB )
{
  if ( pB->iType == Bullet::EGrenade ) {
    this->causeDamage( pB );
    return true;
  }
  
  if ( pB->iOwner == 0 ) {
    return false;
  }
  
  switch ( pB->iOwner->objectType() ) {
    case ( ObjectID::TYPE_YOUKO ):
    case ( ObjectID::TYPE_ERIC ):
    case ( ObjectID::TYPE_SIMON ):
    case ( ObjectID::TYPE_TANK ):
    case ( ObjectID::TYPE_PLAYER ):
    case ( ObjectID::TYPE_GASLEAK ): {
      if ( this->hasProperty( GameObject::PROP_SHOTPARALYSES ) == true ) {
       // The "paralyses"-flag was up so we make this object uncapable of
       // shooting back for a while.
       this->setCounter( RELOAD_COUNTER_INDEX, 10 );
      }
      // This bullet causes damage.
      this->causeDamage( pB );
      break;
    }
    default: {
      return false;
    }
  }
  return true;
}



/** Redraws this alien.
 */
void Alien::redraw( RedrawQueue* pQueue )
{
  if ( this->hidden() == true ) {
    return;
  }
  
  eng2d::Vec2D p( this->position() );
  int alX = static_cast<int>( p.x() ) - Map::scrollX;
  int alY = static_cast<int>( p.y() ) - Map::scrollY;
  
  BITMAP* pS = m_animation.currentFrame().asBitmap();
  
  alX -= pS->w / 2;
  alY -= pS->h / 2;

  pQueue->addRotatedSprite( this->redrawPriority(), alX,alY, itofix( m_angle ),
                            pS );
}



/** Sets the graphicsvector.
 */
void Alien::setGraphics( const vector< vector<RLE_SPRITE*>* >* pGfx )
{
  m_pGfxTable = pGfx;
}



///
/// Getter methods
/// ==============

/** Tells if we're reloading
 */
bool Alien::reloading() const
{
  return ( this->getCounter( RELOAD_COUNTER_INDEX ) < 0 ) ? false : true;
}



/** Returns the redraw priority
 */
int Alien::redrawPriority() const
{
  if ( this->state() == GameObject::STATE_KILLED ) {
    return RedrawQueue::PRI_KILLED;
  }
  return RedrawQueue::PRI_NORMAL;
}


} // end of namespace

